package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  AppSKey,
  NwkSEncKey,
  SNwkSIntKey,
  FNwkSIntKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SessionKeysAbpV1_1(
    fNwkSIntKey: Option[FNwkSIntKey] = None,
    sNwkSIntKey: Option[SNwkSIntKey] = None,
    nwkSEncKey: Option[NwkSEncKey] = None,
    appSKey: Option[AppSKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_1 = {
    import SessionKeysAbpV1_1.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_1
      .builder()
      .optionallyWith(
        fNwkSIntKey.map(value => FNwkSIntKey.unwrap(value): java.lang.String)
      )(_.fNwkSIntKey)
      .optionallyWith(
        sNwkSIntKey.map(value => SNwkSIntKey.unwrap(value): java.lang.String)
      )(_.sNwkSIntKey)
      .optionallyWith(
        nwkSEncKey.map(value => NwkSEncKey.unwrap(value): java.lang.String)
      )(_.nwkSEncKey)
      .optionallyWith(
        appSKey.map(value => AppSKey.unwrap(value): java.lang.String)
      )(_.appSKey)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SessionKeysAbpV1_1.ReadOnly =
    zio.aws.iotwireless.model.SessionKeysAbpV1_1.wrap(buildAwsValue())
}
object SessionKeysAbpV1_1 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_1
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SessionKeysAbpV1_1 =
      zio.aws.iotwireless.model.SessionKeysAbpV1_1(
        fNwkSIntKey.map(value => value),
        sNwkSIntKey.map(value => value),
        nwkSEncKey.map(value => value),
        appSKey.map(value => value)
      )
    def fNwkSIntKey: Option[FNwkSIntKey]
    def sNwkSIntKey: Option[SNwkSIntKey]
    def nwkSEncKey: Option[NwkSEncKey]
    def appSKey: Option[AppSKey]
    def getFNwkSIntKey: ZIO[Any, AwsError, FNwkSIntKey] =
      AwsError.unwrapOptionField("fNwkSIntKey", fNwkSIntKey)
    def getSNwkSIntKey: ZIO[Any, AwsError, SNwkSIntKey] =
      AwsError.unwrapOptionField("sNwkSIntKey", sNwkSIntKey)
    def getNwkSEncKey: ZIO[Any, AwsError, NwkSEncKey] =
      AwsError.unwrapOptionField("nwkSEncKey", nwkSEncKey)
    def getAppSKey: ZIO[Any, AwsError, AppSKey] =
      AwsError.unwrapOptionField("appSKey", appSKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_1
  ) extends zio.aws.iotwireless.model.SessionKeysAbpV1_1.ReadOnly {
    override val fNwkSIntKey: Option[FNwkSIntKey] = scala
      .Option(impl.fNwkSIntKey())
      .map(value => zio.aws.iotwireless.model.primitives.FNwkSIntKey(value))
    override val sNwkSIntKey: Option[SNwkSIntKey] = scala
      .Option(impl.sNwkSIntKey())
      .map(value => zio.aws.iotwireless.model.primitives.SNwkSIntKey(value))
    override val nwkSEncKey: Option[NwkSEncKey] = scala
      .Option(impl.nwkSEncKey())
      .map(value => zio.aws.iotwireless.model.primitives.NwkSEncKey(value))
    override val appSKey: Option[AppSKey] = scala
      .Option(impl.appSKey())
      .map(value => zio.aws.iotwireless.model.primitives.AppSKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SessionKeysAbpV1_1
  ): zio.aws.iotwireless.model.SessionKeysAbpV1_1.ReadOnly = new Wrapper(impl)
}
