package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{ResourceType, ResourceIdentifier}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResetResourceLogLevelRequest(
    resourceIdentifier: ResourceIdentifier,
    resourceType: ResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ResetResourceLogLevelRequest = {
    import ResetResourceLogLevelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ResetResourceLogLevelRequest
      .builder()
      .resourceIdentifier(
        ResourceIdentifier.unwrap(resourceIdentifier): java.lang.String
      )
      .resourceType(ResourceType.unwrap(resourceType): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ResetResourceLogLevelRequest.ReadOnly =
    zio.aws.iotwireless.model.ResetResourceLogLevelRequest.wrap(buildAwsValue())
}
object ResetResourceLogLevelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ResetResourceLogLevelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ResetResourceLogLevelRequest =
      zio.aws.iotwireless.model
        .ResetResourceLogLevelRequest(resourceIdentifier, resourceType)
    def resourceIdentifier: ResourceIdentifier
    def resourceType: ResourceType
    def getResourceIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(resourceIdentifier)
    def getResourceType: ZIO[Any, Nothing, ResourceType] =
      ZIO.succeed(resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ResetResourceLogLevelRequest
  ) extends zio.aws.iotwireless.model.ResetResourceLogLevelRequest.ReadOnly {
    override val resourceIdentifier: ResourceIdentifier =
      zio.aws.iotwireless.model.primitives
        .ResourceIdentifier(impl.resourceIdentifier())
    override val resourceType: ResourceType =
      zio.aws.iotwireless.model.primitives.ResourceType(impl.resourceType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ResetResourceLogLevelRequest
  ): zio.aws.iotwireless.model.ResetResourceLogLevelRequest.ReadOnly =
    new Wrapper(impl)
}
