package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{Crc, UpdateSignature}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoRaWANUpdateGatewayTaskCreate(
    updateSignature: Option[UpdateSignature] = None,
    sigKeyCrc: Option[Crc] = None,
    currentVersion: Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion] =
      None,
    updateVersion: Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskCreate = {
    import LoRaWANUpdateGatewayTaskCreate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskCreate
      .builder()
      .optionallyWith(
        updateSignature.map(value =>
          UpdateSignature.unwrap(value): java.lang.String
        )
      )(_.updateSignature)
      .optionallyWith(
        sigKeyCrc.map(value => Crc.unwrap(value): java.lang.Long)
      )(_.sigKeyCrc)
      .optionallyWith(currentVersion.map(value => value.buildAwsValue()))(
        _.currentVersion
      )
      .optionallyWith(updateVersion.map(value => value.buildAwsValue()))(
        _.updateVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate
      .wrap(buildAwsValue())
}
object LoRaWANUpdateGatewayTaskCreate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskCreate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate =
      zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate(
        updateSignature.map(value => value),
        sigKeyCrc.map(value => value),
        currentVersion.map(value => value.asEditable),
        updateVersion.map(value => value.asEditable)
      )
    def updateSignature: Option[UpdateSignature]
    def sigKeyCrc: Option[Crc]
    def currentVersion
        : Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly]
    def updateVersion
        : Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly]
    def getUpdateSignature: ZIO[Any, AwsError, UpdateSignature] =
      AwsError.unwrapOptionField("updateSignature", updateSignature)
    def getSigKeyCrc: ZIO[Any, AwsError, Crc] =
      AwsError.unwrapOptionField("sigKeyCrc", sigKeyCrc)
    def getCurrentVersion: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly
    ] = AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getUpdateVersion: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly
    ] = AwsError.unwrapOptionField("updateVersion", updateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskCreate
  ) extends zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate.ReadOnly {
    override val updateSignature: Option[UpdateSignature] = scala
      .Option(impl.updateSignature())
      .map(value => zio.aws.iotwireless.model.primitives.UpdateSignature(value))
    override val sigKeyCrc: Option[Crc] = scala
      .Option(impl.sigKeyCrc())
      .map(value => zio.aws.iotwireless.model.primitives.Crc(value))
    override val currentVersion
        : Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly] =
      scala
        .Option(impl.currentVersion())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANGatewayVersion.wrap(value)
        )
    override val updateVersion
        : Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly] =
      scala
        .Option(impl.updateVersion())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANGatewayVersion.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskCreate
  ): zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskCreate.ReadOnly =
    new Wrapper(impl)
}
