package zio.aws.iotwireless.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.{
  SessionTimeout,
  SessionStartTimeTimestamp,
  DlFreq,
  DlDr
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LoRaWANMulticastSession(
    dlDr: Option[DlDr] = None,
    dlFreq: Option[DlFreq] = None,
    sessionStartTime: Option[SessionStartTimeTimestamp] = None,
    sessionTimeout: Option[SessionTimeout] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastSession = {
    import LoRaWANMulticastSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastSession
      .builder()
      .optionallyWith(dlDr.map(value => DlDr.unwrap(value): Integer))(_.dlDr)
      .optionallyWith(dlFreq.map(value => DlFreq.unwrap(value): Integer))(
        _.dlFreq
      )
      .optionallyWith(
        sessionStartTime.map(value =>
          SessionStartTimeTimestamp.unwrap(value): Instant
        )
      )(_.sessionStartTime)
      .optionallyWith(
        sessionTimeout.map(value => SessionTimeout.unwrap(value): Integer)
      )(_.sessionTimeout)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANMulticastSession.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANMulticastSession.wrap(buildAwsValue())
}
object LoRaWANMulticastSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANMulticastSession =
      zio.aws.iotwireless.model.LoRaWANMulticastSession(
        dlDr.map(value => value),
        dlFreq.map(value => value),
        sessionStartTime.map(value => value),
        sessionTimeout.map(value => value)
      )
    def dlDr: Option[DlDr]
    def dlFreq: Option[DlFreq]
    def sessionStartTime: Option[SessionStartTimeTimestamp]
    def sessionTimeout: Option[SessionTimeout]
    def getDlDr: ZIO[Any, AwsError, DlDr] =
      AwsError.unwrapOptionField("dlDr", dlDr)
    def getDlFreq: ZIO[Any, AwsError, DlFreq] =
      AwsError.unwrapOptionField("dlFreq", dlFreq)
    def getSessionStartTime: ZIO[Any, AwsError, SessionStartTimeTimestamp] =
      AwsError.unwrapOptionField("sessionStartTime", sessionStartTime)
    def getSessionTimeout: ZIO[Any, AwsError, SessionTimeout] =
      AwsError.unwrapOptionField("sessionTimeout", sessionTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastSession
  ) extends zio.aws.iotwireless.model.LoRaWANMulticastSession.ReadOnly {
    override val dlDr: Option[DlDr] = scala
      .Option(impl.dlDr())
      .map(value => zio.aws.iotwireless.model.primitives.DlDr(value))
    override val dlFreq: Option[DlFreq] = scala
      .Option(impl.dlFreq())
      .map(value => zio.aws.iotwireless.model.primitives.DlFreq(value))
    override val sessionStartTime: Option[SessionStartTimeTimestamp] = scala
      .Option(impl.sessionStartTime())
      .map(value =>
        zio.aws.iotwireless.model.primitives.SessionStartTimeTimestamp(value)
      )
    override val sessionTimeout: Option[SessionTimeout] = scala
      .Option(impl.sessionTimeout())
      .map(value => zio.aws.iotwireless.model.primitives.SessionTimeout(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastSession
  ): zio.aws.iotwireless.model.LoRaWANMulticastSession.ReadOnly = new Wrapper(
    impl
  )
}
