package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoRaWANGatewayCurrentVersion(
    currentVersion: Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayCurrentVersion = {
    import LoRaWANGatewayCurrentVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayCurrentVersion
      .builder()
      .optionallyWith(currentVersion.map(value => value.buildAwsValue()))(
        _.currentVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion.wrap(buildAwsValue())
}
object LoRaWANGatewayCurrentVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayCurrentVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion =
      zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion(
        currentVersion.map(value => value.asEditable)
      )
    def currentVersion
        : Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly]
    def getCurrentVersion: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly
    ] = AwsError.unwrapOptionField("currentVersion", currentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayCurrentVersion
  ) extends zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion.ReadOnly {
    override val currentVersion
        : Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly] =
      scala
        .Option(impl.currentVersion())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANGatewayVersion.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayCurrentVersion
  ): zio.aws.iotwireless.model.LoRaWANGatewayCurrentVersion.ReadOnly =
    new Wrapper(impl)
}
