package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{StartTime, RfRegion}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class LoRaWANFuotaTaskGetInfo(
    rfRegion: Option[RfRegion] = None,
    startTime: Option[StartTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANFuotaTaskGetInfo = {
    import LoRaWANFuotaTaskGetInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANFuotaTaskGetInfo
      .builder()
      .optionallyWith(
        rfRegion.map(value => RfRegion.unwrap(value): java.lang.String)
      )(_.rfRegion)
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo.wrap(buildAwsValue())
}
object LoRaWANFuotaTaskGetInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANFuotaTaskGetInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo =
      zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo(
        rfRegion.map(value => value),
        startTime.map(value => value)
      )
    def rfRegion: Option[RfRegion]
    def startTime: Option[StartTime]
    def getRfRegion: ZIO[Any, AwsError, RfRegion] =
      AwsError.unwrapOptionField("rfRegion", rfRegion)
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANFuotaTaskGetInfo
  ) extends zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo.ReadOnly {
    override val rfRegion: Option[RfRegion] = scala
      .Option(impl.rfRegion())
      .map(value => zio.aws.iotwireless.model.primitives.RfRegion(value))
    override val startTime: Option[StartTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.iotwireless.model.primitives.StartTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANFuotaTaskGetInfo
  ): zio.aws.iotwireless.model.LoRaWANFuotaTaskGetInfo.ReadOnly = new Wrapper(
    impl
  )
}
