package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessGatewayTaskDefinitionArn,
  WirelessGatewayTaskName,
  AutoCreateTasks
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayTaskDefinitionResponse(
    autoCreateTasks: Option[AutoCreateTasks] = None,
    name: Option[WirelessGatewayTaskName] = None,
    update: Option[zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate] =
      None,
    arn: Option[WirelessGatewayTaskDefinitionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse = {
    import GetWirelessGatewayTaskDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse
      .builder()
      .optionallyWith(
        autoCreateTasks.map(value =>
          AutoCreateTasks.unwrap(value): java.lang.Boolean
        )
      )(_.autoCreateTasks)
      .optionallyWith(
        name.map(value =>
          WirelessGatewayTaskName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(update.map(value => value.buildAwsValue()))(_.update)
      .optionallyWith(
        arn.map(value =>
          WirelessGatewayTaskDefinitionArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse
      .wrap(buildAwsValue())
}
object GetWirelessGatewayTaskDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse =
      zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse(
        autoCreateTasks.map(value => value),
        name.map(value => value),
        update.map(value => value.asEditable),
        arn.map(value => value)
      )
    def autoCreateTasks: Option[AutoCreateTasks]
    def name: Option[WirelessGatewayTaskName]
    def update: Option[
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.ReadOnly
    ]
    def arn: Option[WirelessGatewayTaskDefinitionArn]
    def getAutoCreateTasks: ZIO[Any, AwsError, AutoCreateTasks] =
      AwsError.unwrapOptionField("autoCreateTasks", autoCreateTasks)
    def getName: ZIO[Any, AwsError, WirelessGatewayTaskName] =
      AwsError.unwrapOptionField("name", name)
    def getUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.ReadOnly
    ] = AwsError.unwrapOptionField("update", update)
    def getArn: ZIO[Any, AwsError, WirelessGatewayTaskDefinitionArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse.ReadOnly {
    override val autoCreateTasks: Option[AutoCreateTasks] = scala
      .Option(impl.autoCreateTasks())
      .map(value => zio.aws.iotwireless.model.primitives.AutoCreateTasks(value))
    override val name: Option[WirelessGatewayTaskName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayTaskName(value)
      )
    override val update: Option[
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.ReadOnly
    ] = scala
      .Option(impl.update())
      .map(value =>
        zio.aws.iotwireless.model.UpdateWirelessGatewayTaskCreate.wrap(value)
      )
    override val arn: Option[WirelessGatewayTaskDefinitionArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives
          .WirelessGatewayTaskDefinitionArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse
  ): zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
