package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ThingName,
  ThingArn,
  WirelessGatewayId,
  WirelessGatewayArn,
  WirelessGatewayName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayResponse(
    name: Option[WirelessGatewayName] = None,
    id: Option[WirelessGatewayId] = None,
    description: Option[Description] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANGateway] = None,
    arn: Option[WirelessGatewayArn] = None,
    thingName: Option[ThingName] = None,
    thingArn: Option[ThingArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse = {
    import GetWirelessGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse
      .builder()
      .optionallyWith(
        name.map(value => WirelessGatewayName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => WirelessGatewayId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        arn.map(value => WirelessGatewayArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessGatewayResponse.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayResponse.wrap(buildAwsValue())
}
object GetWirelessGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetWirelessGatewayResponse =
      zio.aws.iotwireless.model.GetWirelessGatewayResponse(
        name.map(value => value),
        id.map(value => value),
        description.map(value => value),
        loRaWAN.map(value => value.asEditable),
        arn.map(value => value),
        thingName.map(value => value),
        thingArn.map(value => value)
      )
    def name: Option[WirelessGatewayName]
    def id: Option[WirelessGatewayId]
    def description: Option[Description]
    def loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly]
    def arn: Option[WirelessGatewayArn]
    def thingName: Option[ThingName]
    def thingArn: Option[ThingArn]
    def getName: ZIO[Any, AwsError, WirelessGatewayName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, WirelessGatewayId] =
      AwsError.unwrapOptionField("id", id)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getArn: ZIO[Any, AwsError, WirelessGatewayArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayResponse.ReadOnly {
    override val name: Option[WirelessGatewayName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayName(value)
      )
    override val id: Option[WirelessGatewayId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayId(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly] = scala
      .Option(impl.loRaWAN())
      .map(value => zio.aws.iotwireless.model.LoRaWANGateway.wrap(value))
    override val arn: Option[WirelessGatewayArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayArn(value)
      )
    override val thingName: Option[ThingName] = scala
      .Option(impl.thingName())
      .map(value => zio.aws.iotwireless.model.primitives.ThingName(value))
    override val thingArn: Option[ThingArn] = scala
      .Option(impl.thingArn())
      .map(value => zio.aws.iotwireless.model.primitives.ThingArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayResponse
  ): zio.aws.iotwireless.model.GetWirelessGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
