package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{CertificatePEM, EndPoint}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetServiceEndpointResponse(
    serviceType: Option[zio.aws.iotwireless.model.WirelessGatewayServiceType] =
      None,
    serviceEndpoint: Option[EndPoint] = None,
    serverTrust: Option[CertificatePEM] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointResponse = {
    import GetServiceEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointResponse
      .builder()
      .optionallyWith(serviceType.map(value => value.unwrap))(_.serviceType)
      .optionallyWith(
        serviceEndpoint.map(value => EndPoint.unwrap(value): java.lang.String)
      )(_.serviceEndpoint)
      .optionallyWith(
        serverTrust.map(value => CertificatePEM.unwrap(value): java.lang.String)
      )(_.serverTrust)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetServiceEndpointResponse.ReadOnly =
    zio.aws.iotwireless.model.GetServiceEndpointResponse.wrap(buildAwsValue())
}
object GetServiceEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetServiceEndpointResponse =
      zio.aws.iotwireless.model.GetServiceEndpointResponse(
        serviceType.map(value => value),
        serviceEndpoint.map(value => value),
        serverTrust.map(value => value)
      )
    def serviceType
        : Option[zio.aws.iotwireless.model.WirelessGatewayServiceType]
    def serviceEndpoint: Option[EndPoint]
    def serverTrust: Option[CertificatePEM]
    def getServiceType: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.WirelessGatewayServiceType
    ] = AwsError.unwrapOptionField("serviceType", serviceType)
    def getServiceEndpoint: ZIO[Any, AwsError, EndPoint] =
      AwsError.unwrapOptionField("serviceEndpoint", serviceEndpoint)
    def getServerTrust: ZIO[Any, AwsError, CertificatePEM] =
      AwsError.unwrapOptionField("serverTrust", serverTrust)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointResponse
  ) extends zio.aws.iotwireless.model.GetServiceEndpointResponse.ReadOnly {
    override val serviceType
        : Option[zio.aws.iotwireless.model.WirelessGatewayServiceType] = scala
      .Option(impl.serviceType())
      .map(value =>
        zio.aws.iotwireless.model.WirelessGatewayServiceType.wrap(value)
      )
    override val serviceEndpoint: Option[EndPoint] = scala
      .Option(impl.serviceEndpoint())
      .map(value => zio.aws.iotwireless.model.primitives.EndPoint(value))
    override val serverTrust: Option[CertificatePEM] = scala
      .Option(impl.serverTrust())
      .map(value => zio.aws.iotwireless.model.primitives.CertificatePEM(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetServiceEndpointResponse
  ): zio.aws.iotwireless.model.GetServiceEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
