package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessGatewayId,
  WirelessDeviceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetNetworkAnalyzerConfigurationResponse(
    traceContent: Option[zio.aws.iotwireless.model.TraceContent] = None,
    wirelessDevices: Option[Iterable[WirelessDeviceId]] = None,
    wirelessGateways: Option[Iterable[WirelessGatewayId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationResponse = {
    import GetNetworkAnalyzerConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationResponse
      .builder()
      .optionallyWith(traceContent.map(value => value.buildAwsValue()))(
        _.traceContent
      )
      .optionallyWith(
        wirelessDevices.map(value =>
          value.map { item =>
            WirelessDeviceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.wirelessDevices)
      .optionallyWith(
        wirelessGateways.map(value =>
          value.map { item =>
            WirelessGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.wirelessGateways)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationResponse.ReadOnly =
    zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationResponse
      .wrap(buildAwsValue())
}
object GetNetworkAnalyzerConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationResponse =
      zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationResponse(
        traceContent.map(value => value.asEditable),
        wirelessDevices.map(value => value),
        wirelessGateways.map(value => value)
      )
    def traceContent: Option[zio.aws.iotwireless.model.TraceContent.ReadOnly]
    def wirelessDevices: Option[List[WirelessDeviceId]]
    def wirelessGateways: Option[List[WirelessGatewayId]]
    def getTraceContent
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.TraceContent.ReadOnly] =
      AwsError.unwrapOptionField("traceContent", traceContent)
    def getWirelessDevices: ZIO[Any, AwsError, List[WirelessDeviceId]] =
      AwsError.unwrapOptionField("wirelessDevices", wirelessDevices)
    def getWirelessGateways: ZIO[Any, AwsError, List[WirelessGatewayId]] =
      AwsError.unwrapOptionField("wirelessGateways", wirelessGateways)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationResponse
  ) extends zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationResponse.ReadOnly {
    override val traceContent
        : Option[zio.aws.iotwireless.model.TraceContent.ReadOnly] = scala
      .Option(impl.traceContent())
      .map(value => zio.aws.iotwireless.model.TraceContent.wrap(value))
    override val wirelessDevices: Option[List[WirelessDeviceId]] = scala
      .Option(impl.wirelessDevices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.primitives.WirelessDeviceId(item)
        }.toList
      )
    override val wirelessGateways: Option[List[WirelessGatewayId]] = scala
      .Option(impl.wirelessGateways())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.primitives.WirelessGatewayId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetNetworkAnalyzerConfigurationResponse
  ): zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
