package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait EventNotificationPartnerType {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.EventNotificationPartnerType
}
object EventNotificationPartnerType {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.EventNotificationPartnerType
  ): zio.aws.iotwireless.model.EventNotificationPartnerType = value match {
    case software.amazon.awssdk.services.iotwireless.model.EventNotificationPartnerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.EventNotificationPartnerType.SIDEWALK =>
      val r = Sidewalk
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.EventNotificationPartnerType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.EventNotificationPartnerType =
      software.amazon.awssdk.services.iotwireless.model.EventNotificationPartnerType.UNKNOWN_TO_SDK_VERSION
  }
  case object Sidewalk
      extends zio.aws.iotwireless.model.EventNotificationPartnerType {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.EventNotificationPartnerType =
      software.amazon.awssdk.services.iotwireless.model.EventNotificationPartnerType.SIDEWALK
  }
}
