package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.WirelessGatewayId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteWirelessGatewayRequest(id: WirelessGatewayId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayRequest = {
    import DeleteWirelessGatewayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayRequest
      .builder()
      .id(WirelessGatewayId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DeleteWirelessGatewayRequest.ReadOnly =
    zio.aws.iotwireless.model.DeleteWirelessGatewayRequest.wrap(buildAwsValue())
}
object DeleteWirelessGatewayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.DeleteWirelessGatewayRequest =
      zio.aws.iotwireless.model.DeleteWirelessGatewayRequest(id)
    def id: WirelessGatewayId
    def getId: ZIO[Any, Nothing, WirelessGatewayId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayRequest
  ) extends zio.aws.iotwireless.model.DeleteWirelessGatewayRequest.ReadOnly {
    override val id: WirelessGatewayId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteWirelessGatewayRequest
  ): zio.aws.iotwireless.model.DeleteWirelessGatewayRequest.ReadOnly =
    new Wrapper(impl)
}
