package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessGatewayTaskDefinitionArn,
  WirelessGatewayTaskDefinitionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateWirelessGatewayTaskDefinitionResponse(
    id: Option[WirelessGatewayTaskDefinitionId] = None,
    arn: Option[WirelessGatewayTaskDefinitionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse = {
    import CreateWirelessGatewayTaskDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse
      .builder()
      .optionallyWith(
        id.map(value =>
          WirelessGatewayTaskDefinitionId.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        arn.map(value =>
          WirelessGatewayTaskDefinitionArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse.ReadOnly =
    zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse
      .wrap(buildAwsValue())
}
object CreateWirelessGatewayTaskDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse =
      zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse(
        id.map(value => value),
        arn.map(value => value)
      )
    def id: Option[WirelessGatewayTaskDefinitionId]
    def arn: Option[WirelessGatewayTaskDefinitionArn]
    def getId: ZIO[Any, AwsError, WirelessGatewayTaskDefinitionId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, WirelessGatewayTaskDefinitionArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse
  ) extends zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse.ReadOnly {
    override val id: Option[WirelessGatewayTaskDefinitionId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives
          .WirelessGatewayTaskDefinitionId(value)
      )
    override val arn: Option[WirelessGatewayTaskDefinitionArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives
          .WirelessGatewayTaskDefinitionArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse
  ): zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse.ReadOnly =
    new Wrapper(impl)
}
