package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{FuotaTaskId, FuotaTaskArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFuotaTaskResponse(
    arn: Option[FuotaTaskArn] = None,
    id: Option[FuotaTaskId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskResponse = {
    import CreateFuotaTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskResponse
      .builder()
      .optionallyWith(
        arn.map(value => FuotaTaskArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => FuotaTaskId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.CreateFuotaTaskResponse.ReadOnly =
    zio.aws.iotwireless.model.CreateFuotaTaskResponse.wrap(buildAwsValue())
}
object CreateFuotaTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateFuotaTaskResponse =
      zio.aws.iotwireless.model.CreateFuotaTaskResponse(
        arn.map(value => value),
        id.map(value => value)
      )
    def arn: Option[FuotaTaskArn]
    def id: Option[FuotaTaskId]
    def getArn: ZIO[Any, AwsError, FuotaTaskArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, FuotaTaskId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskResponse
  ) extends zio.aws.iotwireless.model.CreateFuotaTaskResponse.ReadOnly {
    override val arn: Option[FuotaTaskArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskArn(value))
    override val id: Option[FuotaTaskId] = scala
      .Option(impl.id())
      .map(value => zio.aws.iotwireless.model.primitives.FuotaTaskId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateFuotaTaskResponse
  ): zio.aws.iotwireless.model.CreateFuotaTaskResponse.ReadOnly = new Wrapper(
    impl
  )
}
