package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.ClientRequestToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateAwsAccountWithPartnerAccountRequest(
    sidewalk: zio.aws.iotwireless.model.SidewalkAccountInfo,
    clientRequestToken: Option[ClientRequestToken] = None,
    tags: Option[Iterable[zio.aws.iotwireless.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest = {
    import AssociateAwsAccountWithPartnerAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest
      .builder()
      .sidewalk(sidewalk.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest.ReadOnly =
    zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest
      .wrap(buildAwsValue())
}
object AssociateAwsAccountWithPartnerAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest =
      zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest(
        sidewalk.asEditable,
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sidewalk: zio.aws.iotwireless.model.SidewalkAccountInfo.ReadOnly
    def clientRequestToken: Option[ClientRequestToken]
    def tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]]
    def getSidewalk: ZIO[
      Any,
      Nothing,
      zio.aws.iotwireless.model.SidewalkAccountInfo.ReadOnly
    ] = ZIO.succeed(sidewalk)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest
  ) extends zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest.ReadOnly {
    override val sidewalk
        : zio.aws.iotwireless.model.SidewalkAccountInfo.ReadOnly =
      zio.aws.iotwireless.model.SidewalkAccountInfo.wrap(impl.sidewalk())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ClientRequestToken(value)
      )
    override val tags: Option[List[zio.aws.iotwireless.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest
  ): zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest.ReadOnly =
    new Wrapper(impl)
}
