package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  SceneMetadataValue,
  SceneCapability,
  S3Url,
  Description,
  Name,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSceneRequest(
    workspaceId: Id,
    sceneId: Id,
    contentLocation: Optional[S3Url] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    capabilities: Optional[Iterable[SceneCapability]] = Optional.Absent,
    sceneMetadata: Optional[Map[Name, SceneMetadataValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest = {
    import UpdateSceneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .sceneId(Id.unwrap(sceneId): java.lang.String)
      .optionallyWith(
        contentLocation.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.contentLocation)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            SceneCapability.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capabilities)
      .optionallyWith(
        sceneMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> (SceneMetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.sceneMetadata)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.UpdateSceneRequest.ReadOnly =
    zio.aws.iottwinmaker.model.UpdateSceneRequest.wrap(buildAwsValue())
}
object UpdateSceneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UpdateSceneRequest =
      zio.aws.iottwinmaker.model.UpdateSceneRequest(
        workspaceId,
        sceneId,
        contentLocation.map(value => value),
        description.map(value => value),
        capabilities.map(value => value),
        sceneMetadata.map(value => value)
      )
    def workspaceId: Id
    def sceneId: Id
    def contentLocation: Optional[S3Url]
    def description: Optional[Description]
    def capabilities: Optional[List[SceneCapability]]
    def sceneMetadata: Optional[Map[Name, SceneMetadataValue]]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getSceneId: ZIO[Any, Nothing, Id] = ZIO.succeed(sceneId)
    def getContentLocation: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("contentLocation", contentLocation)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCapabilities: ZIO[Any, AwsError, List[SceneCapability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getSceneMetadata: ZIO[Any, AwsError, Map[Name, SceneMetadataValue]] =
      AwsError.unwrapOptionField("sceneMetadata", sceneMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest
  ) extends zio.aws.iottwinmaker.model.UpdateSceneRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val sceneId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.sceneId())
    override val contentLocation: Optional[S3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.contentLocation())
      .map(value => zio.aws.iottwinmaker.model.primitives.S3Url(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val capabilities: Optional[List[SceneCapability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.primitives.SceneCapability(item)
          }.toList
        )
    override val sceneMetadata: Optional[Map[Name, SceneMetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sceneMetadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iottwinmaker.model.primitives
                .Name(key) -> zio.aws.iottwinmaker.model.primitives
                .SceneMetadataValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest
  ): zio.aws.iottwinmaker.model.UpdateSceneRequest.ReadOnly = new Wrapper(impl)
}
