package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{Timestamp, Id}
import scala.jdk.CollectionConverters._
final case class SyncResourceSummary(
    resourceType: Optional[zio.aws.iottwinmaker.model.SyncResourceType] =
      Optional.Absent,
    externalId: Optional[Id] = Optional.Absent,
    resourceId: Optional[Id] = Optional.Absent,
    status: Optional[zio.aws.iottwinmaker.model.SyncResourceStatus] =
      Optional.Absent,
    updateDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceSummary = {
    import SyncResourceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.SyncResourceSummary
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        externalId.map(value => Id.unwrap(value): java.lang.String)
      )(_.externalId)
      .optionallyWith(
        resourceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        updateDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.updateDateTime)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.SyncResourceSummary.ReadOnly =
    zio.aws.iottwinmaker.model.SyncResourceSummary.wrap(buildAwsValue())
}
object SyncResourceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.SyncResourceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.SyncResourceSummary =
      zio.aws.iottwinmaker.model.SyncResourceSummary(
        resourceType.map(value => value),
        externalId.map(value => value),
        resourceId.map(value => value),
        status.map(value => value.asEditable),
        updateDateTime.map(value => value)
      )
    def resourceType: Optional[zio.aws.iottwinmaker.model.SyncResourceType]
    def externalId: Optional[Id]
    def resourceId: Optional[Id]
    def status: Optional[zio.aws.iottwinmaker.model.SyncResourceStatus.ReadOnly]
    def updateDateTime: Optional[Timestamp]
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.SyncResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getExternalId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getResourceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.SyncResourceStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getUpdateDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updateDateTime", updateDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SyncResourceSummary
  ) extends zio.aws.iottwinmaker.model.SyncResourceSummary.ReadOnly {
    override val resourceType
        : Optional[zio.aws.iottwinmaker.model.SyncResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.iottwinmaker.model.SyncResourceType.wrap(value))
    override val externalId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => zio.aws.iottwinmaker.model.primitives.Id(value))
    override val resourceId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.iottwinmaker.model.primitives.Id(value))
    override val status
        : Optional[zio.aws.iottwinmaker.model.SyncResourceStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iottwinmaker.model.SyncResourceStatus.wrap(value))
    override val updateDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updateDateTime())
      .map(value => zio.aws.iottwinmaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SyncResourceSummary
  ): zio.aws.iottwinmaker.model.SyncResourceSummary.ReadOnly = new Wrapper(impl)
}
