package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  Timestamp,
  SyncSource,
  Id,
  TwinMakerArn
}
import scala.jdk.CollectionConverters._
final case class SyncJobSummary(
    arn: Optional[TwinMakerArn] = Optional.Absent,
    workspaceId: Optional[Id] = Optional.Absent,
    syncSource: Optional[SyncSource] = Optional.Absent,
    status: Optional[zio.aws.iottwinmaker.model.SyncJobStatus] =
      Optional.Absent,
    creationDateTime: Optional[Timestamp] = Optional.Absent,
    updateDateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.SyncJobSummary = {
    import SyncJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.SyncJobSummary
      .builder()
      .optionallyWith(
        arn.map(value => TwinMakerArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        workspaceId.map(value => Id.unwrap(value): java.lang.String)
      )(_.workspaceId)
      .optionallyWith(
        syncSource.map(value => SyncSource.unwrap(value): java.lang.String)
      )(_.syncSource)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(
        creationDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDateTime)
      .optionallyWith(
        updateDateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.updateDateTime)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.SyncJobSummary.ReadOnly =
    zio.aws.iottwinmaker.model.SyncJobSummary.wrap(buildAwsValue())
}
object SyncJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.SyncJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.SyncJobSummary =
      zio.aws.iottwinmaker.model.SyncJobSummary(
        arn.map(value => value),
        workspaceId.map(value => value),
        syncSource.map(value => value),
        status.map(value => value.asEditable),
        creationDateTime.map(value => value),
        updateDateTime.map(value => value)
      )
    def arn: Optional[TwinMakerArn]
    def workspaceId: Optional[Id]
    def syncSource: Optional[SyncSource]
    def status: Optional[zio.aws.iottwinmaker.model.SyncJobStatus.ReadOnly]
    def creationDateTime: Optional[Timestamp]
    def updateDateTime: Optional[Timestamp]
    def getArn: ZIO[Any, AwsError, TwinMakerArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getWorkspaceId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("workspaceId", workspaceId)
    def getSyncSource: ZIO[Any, AwsError, SyncSource] =
      AwsError.unwrapOptionField("syncSource", syncSource)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.SyncJobStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getCreationDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDateTime", creationDateTime)
    def getUpdateDateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updateDateTime", updateDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SyncJobSummary
  ) extends zio.aws.iottwinmaker.model.SyncJobSummary.ReadOnly {
    override val arn: Optional[TwinMakerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iottwinmaker.model.primitives.TwinMakerArn(value))
    override val workspaceId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.workspaceId())
      .map(value => zio.aws.iottwinmaker.model.primitives.Id(value))
    override val syncSource: Optional[SyncSource] = zio.aws.core.internal
      .optionalFromNullable(impl.syncSource())
      .map(value => zio.aws.iottwinmaker.model.primitives.SyncSource(value))
    override val status
        : Optional[zio.aws.iottwinmaker.model.SyncJobStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iottwinmaker.model.SyncJobStatus.wrap(value))
    override val creationDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDateTime())
      .map(value => zio.aws.iottwinmaker.model.primitives.Timestamp(value))
    override val updateDateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updateDateTime())
      .map(value => zio.aws.iottwinmaker.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SyncJobSummary
  ): zio.aws.iottwinmaker.model.SyncJobSummary.ReadOnly = new Wrapper(impl)
}
