package zio.aws.iottwinmaker.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{MaxResults, NextToken, Id}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListComponentTypesResponse(
    workspaceId: Id,
    componentTypeSummaries: Iterable[
      zio.aws.iottwinmaker.model.ComponentTypeSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse = {
    import ListComponentTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .componentTypeSummaries(componentTypeSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.ListComponentTypesResponse.ReadOnly =
    zio.aws.iottwinmaker.model.ListComponentTypesResponse.wrap(buildAwsValue())
}
object ListComponentTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListComponentTypesResponse =
      zio.aws.iottwinmaker.model.ListComponentTypesResponse(
        workspaceId,
        componentTypeSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def workspaceId: Id
    def componentTypeSummaries
        : List[zio.aws.iottwinmaker.model.ComponentTypeSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getComponentTypeSummaries: ZIO[Any, Nothing, List[
      zio.aws.iottwinmaker.model.ComponentTypeSummary.ReadOnly
    ]] = ZIO.succeed(componentTypeSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse
  ) extends zio.aws.iottwinmaker.model.ListComponentTypesResponse.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val componentTypeSummaries
        : List[zio.aws.iottwinmaker.model.ComponentTypeSummary.ReadOnly] = impl
      .componentTypeSummaries()
      .asScala
      .map { item =>
        zio.aws.iottwinmaker.model.ComponentTypeSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iottwinmaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse
  ): zio.aws.iottwinmaker.model.ListComponentTypesResponse.ReadOnly =
    new Wrapper(impl)
}
