package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchPutPropertyError(
    errorCode: String,
    errorMessage: String,
    entry: zio.aws.iottwinmaker.model.PropertyValueEntry
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyError = {
    import BatchPutPropertyError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyError
      .builder()
      .errorCode(errorCode: java.lang.String)
      .errorMessage(errorMessage: java.lang.String)
      .entry(entry.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.BatchPutPropertyError.ReadOnly =
    zio.aws.iottwinmaker.model.BatchPutPropertyError.wrap(buildAwsValue())
}
object BatchPutPropertyError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.BatchPutPropertyError =
      zio.aws.iottwinmaker.model
        .BatchPutPropertyError(errorCode, errorMessage, entry.asEditable)
    def errorCode: String
    def errorMessage: String
    def entry: zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly
    def getErrorCode: ZIO[Any, Nothing, String] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, String] = ZIO.succeed(errorMessage)
    def getEntry: ZIO[
      Any,
      Nothing,
      zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly
    ] = ZIO.succeed(entry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyError
  ) extends zio.aws.iottwinmaker.model.BatchPutPropertyError.ReadOnly {
    override val errorCode: String = impl.errorCode(): String
    override val errorMessage: String = impl.errorMessage(): String
    override val entry: zio.aws.iottwinmaker.model.PropertyValueEntry.ReadOnly =
      zio.aws.iottwinmaker.model.PropertyValueEntry.wrap(impl.entry())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyError
  ): zio.aws.iottwinmaker.model.BatchPutPropertyError.ReadOnly = new Wrapper(
    impl
  )
}
