package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.ComponentTypeId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Relationship(
    targetComponentTypeId: Optional[ComponentTypeId] = Optional.Absent,
    relationshipType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.Relationship = {
    import Relationship.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.Relationship
      .builder()
      .optionallyWith(
        targetComponentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.targetComponentTypeId)
      .optionallyWith(relationshipType.map(value => value: java.lang.String))(
        _.relationshipType
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.Relationship.ReadOnly =
    zio.aws.iottwinmaker.model.Relationship.wrap(buildAwsValue())
}
object Relationship {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.Relationship
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.Relationship =
      zio.aws.iottwinmaker.model.Relationship(
        targetComponentTypeId.map(value => value),
        relationshipType.map(value => value)
      )
    def targetComponentTypeId: Optional[ComponentTypeId]
    def relationshipType: Optional[String]
    def getTargetComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("targetComponentTypeId", targetComponentTypeId)
    def getRelationshipType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("relationshipType", relationshipType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.Relationship
  ) extends zio.aws.iottwinmaker.model.Relationship.ReadOnly {
    override val targetComponentTypeId: Optional[ComponentTypeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetComponentTypeId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
        )
    override val relationshipType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.relationshipType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.Relationship
  ): zio.aws.iottwinmaker.model.Relationship.ReadOnly = new Wrapper(impl)
}
