package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{EntityId, Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteEntityRequest(
    workspaceId: Id,
    entityId: EntityId,
    isRecursive: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest = {
    import DeleteEntityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .optionallyWith(isRecursive.map(value => value: java.lang.Boolean))(
        _.isRecursive
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.DeleteEntityRequest.ReadOnly =
    zio.aws.iottwinmaker.model.DeleteEntityRequest.wrap(buildAwsValue())
}
object DeleteEntityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.DeleteEntityRequest =
      zio.aws.iottwinmaker.model.DeleteEntityRequest(
        workspaceId,
        entityId,
        isRecursive.map(value => value)
      )
    def workspaceId: Id
    def entityId: EntityId
    def isRecursive: Optional[Boolean]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getIsRecursive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isRecursive", isRecursive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest
  ) extends zio.aws.iottwinmaker.model.DeleteEntityRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val entityId: EntityId =
      zio.aws.iottwinmaker.model.primitives.EntityId(impl.entityId())
    override val isRecursive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isRecursive())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest
  ): zio.aws.iottwinmaker.model.DeleteEntityRequest.ReadOnly = new Wrapper(impl)
}
