package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Name
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PropertyGroupResponse(
    groupType: zio.aws.iottwinmaker.model.GroupType,
    propertyNames: Iterable[Name],
    isInherited: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupResponse = {
    import PropertyGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupResponse
      .builder()
      .groupType(groupType.unwrap)
      .propertyNames(propertyNames.map { item =>
        Name.unwrap(item): java.lang.String
      }.asJavaCollection)
      .isInherited(isInherited: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.PropertyGroupResponse.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyGroupResponse.wrap(buildAwsValue())
}
object PropertyGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyGroupResponse =
      zio.aws.iottwinmaker.model
        .PropertyGroupResponse(groupType, propertyNames, isInherited)
    def groupType: zio.aws.iottwinmaker.model.GroupType
    def propertyNames: List[Name]
    def isInherited: Boolean
    def getGroupType: ZIO[Any, Nothing, zio.aws.iottwinmaker.model.GroupType] =
      ZIO.succeed(groupType)
    def getPropertyNames: ZIO[Any, Nothing, List[Name]] =
      ZIO.succeed(propertyNames)
    def getIsInherited: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isInherited)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupResponse
  ) extends zio.aws.iottwinmaker.model.PropertyGroupResponse.ReadOnly {
    override val groupType: zio.aws.iottwinmaker.model.GroupType =
      zio.aws.iottwinmaker.model.GroupType.wrap(impl.groupType())
    override val propertyNames: List[Name] = impl
      .propertyNames()
      .asScala
      .map { item =>
        zio.aws.iottwinmaker.model.primitives.Name(item)
      }
      .toList
    override val isInherited: Boolean = impl.isInherited(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupResponse
  ): zio.aws.iottwinmaker.model.PropertyGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
