package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{ComponentTypeId, ParentEntityId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEntitiesFilter(
    parentEntityId: Optional[ParentEntityId] = Optional.Absent,
    componentTypeId: Optional[ComponentTypeId] = Optional.Absent,
    externalId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter = {
    import ListEntitiesFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter
      .builder()
      .optionallyWith(
        parentEntityId.map(value =>
          ParentEntityId.unwrap(value): java.lang.String
        )
      )(_.parentEntityId)
      .optionallyWith(
        componentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.componentTypeId)
      .optionallyWith(externalId.map(value => value: java.lang.String))(
        _.externalId
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly =
    zio.aws.iottwinmaker.model.ListEntitiesFilter.wrap(buildAwsValue())
}
object ListEntitiesFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ListEntitiesFilter =
      zio.aws.iottwinmaker.model.ListEntitiesFilter(
        parentEntityId.map(value => value),
        componentTypeId.map(value => value),
        externalId.map(value => value)
      )
    def parentEntityId: Optional[ParentEntityId]
    def componentTypeId: Optional[ComponentTypeId]
    def externalId: Optional[String]
    def getParentEntityId: ZIO[Any, AwsError, ParentEntityId] =
      AwsError.unwrapOptionField("parentEntityId", parentEntityId)
    def getComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("componentTypeId", componentTypeId)
    def getExternalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("externalId", externalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter
  ) extends zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly {
    override val parentEntityId: Optional[ParentEntityId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentEntityId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ParentEntityId(value)
        )
    override val componentTypeId: Optional[ComponentTypeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentTypeId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
        )
    override val externalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesFilter
  ): zio.aws.iottwinmaker.model.ListEntitiesFilter.ReadOnly = new Wrapper(impl)
}
