package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters._
sealed trait ColumnType {
  def unwrap: software.amazon.awssdk.services.iottwinmaker.model.ColumnType
}
object ColumnType {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.ColumnType
  ): zio.aws.iottwinmaker.model.ColumnType = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.ColumnType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.ColumnType.NODE =>
      val r = NODE
      r
    case software.amazon.awssdk.services.iottwinmaker.model.ColumnType.EDGE =>
      val r = EDGE
      r
    case software.amazon.awssdk.services.iottwinmaker.model.ColumnType.VALUE =>
      val r = VALUE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iottwinmaker.model.ColumnType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.ColumnType =
      software.amazon.awssdk.services.iottwinmaker.model.ColumnType.UNKNOWN_TO_SDK_VERSION
  }
  case object NODE extends zio.aws.iottwinmaker.model.ColumnType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.ColumnType =
      software.amazon.awssdk.services.iottwinmaker.model.ColumnType.NODE
  }
  case object EDGE extends zio.aws.iottwinmaker.model.ColumnType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.ColumnType =
      software.amazon.awssdk.services.iottwinmaker.model.ColumnType.EDGE
  }
  case object VALUE extends zio.aws.iottwinmaker.model.ColumnType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.ColumnType =
      software.amazon.awssdk.services.iottwinmaker.model.ColumnType.VALUE
  }
}
