package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  RoleArn,
  S3Location,
  TwinMakerArn,
  Timestamp,
  Description,
  Id
}
import scala.jdk.CollectionConverters._
final case class GetWorkspaceResponse(
    workspaceId: Id,
    arn: TwinMakerArn,
    description: Optional[Description] = Optional.Absent,
    s3Location: S3Location,
    role: RoleArn,
    creationDateTime: Timestamp,
    updateDateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse = {
    import GetWorkspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .s3Location(S3Location.unwrap(s3Location): java.lang.String)
      .role(RoleArn.unwrap(role): java.lang.String)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetWorkspaceResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetWorkspaceResponse.wrap(buildAwsValue())
}
object GetWorkspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetWorkspaceResponse =
      zio.aws.iottwinmaker.model.GetWorkspaceResponse(
        workspaceId,
        arn,
        description.map(value => value),
        s3Location,
        role,
        creationDateTime,
        updateDateTime
      )
    def workspaceId: Id
    def arn: TwinMakerArn
    def description: Optional[Description]
    def s3Location: S3Location
    def role: RoleArn
    def creationDateTime: Timestamp
    def updateDateTime: Timestamp
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getS3Location: ZIO[Any, Nothing, S3Location] = ZIO.succeed(s3Location)
    def getRole: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(role)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse
  ) extends zio.aws.iottwinmaker.model.GetWorkspaceResponse.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val s3Location: S3Location =
      zio.aws.iottwinmaker.model.primitives.S3Location(impl.s3Location())
    override val role: RoleArn =
      zio.aws.iottwinmaker.model.primitives.RoleArn(impl.role())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse
  ): zio.aws.iottwinmaker.model.GetWorkspaceResponse.ReadOnly = new Wrapper(
    impl
  )
}
