package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters._
sealed trait SyncResourceType {
  def unwrap
      : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceType
}
object SyncResourceType {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.SyncResourceType
  ): zio.aws.iottwinmaker.model.SyncResourceType = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.SyncResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.SyncResourceType.ENTITY =>
      val r = ENTITY
      r
    case software.amazon.awssdk.services.iottwinmaker.model.SyncResourceType.COMPONENT_TYPE =>
      val r = COMPONENT_TYPE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iottwinmaker.model.SyncResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceType =
      software.amazon.awssdk.services.iottwinmaker.model.SyncResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ENTITY extends zio.aws.iottwinmaker.model.SyncResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceType =
      software.amazon.awssdk.services.iottwinmaker.model.SyncResourceType.ENTITY
  }
  case object COMPONENT_TYPE
      extends zio.aws.iottwinmaker.model.SyncResourceType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncResourceType =
      software.amazon.awssdk.services.iottwinmaker.model.SyncResourceType.COMPONENT_TYPE
  }
}
