package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPropertyValueHistoryResponse(
    propertyValues: Iterable[zio.aws.iottwinmaker.model.PropertyValueHistory],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse = {
    import GetPropertyValueHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse
      .builder()
      .propertyValues(propertyValues.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse
      .wrap(buildAwsValue())
}
object GetPropertyValueHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse =
      zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse(
        propertyValues.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def propertyValues
        : List[zio.aws.iottwinmaker.model.PropertyValueHistory.ReadOnly]
    def nextToken: Optional[NextToken]
    def getPropertyValues: ZIO[Any, Nothing, List[
      zio.aws.iottwinmaker.model.PropertyValueHistory.ReadOnly
    ]] = ZIO.succeed(propertyValues)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse
  ) extends zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse.ReadOnly {
    override val propertyValues
        : List[zio.aws.iottwinmaker.model.PropertyValueHistory.ReadOnly] = impl
      .propertyValues()
      .asScala
      .map { item =>
        zio.aws.iottwinmaker.model.PropertyValueHistory.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse
  ): zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
