package zio.aws.iottwinmaker
import zio.aws.iottwinmaker.model.CreateSyncJobResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.iottwinmaker.model.{
  ListComponentTypesRequest,
  CreateSyncJobRequest,
  CreateWorkspaceRequest,
  BatchPutPropertyValuesRequest,
  DeleteWorkspaceRequest,
  ListWorkspacesRequest,
  CreateComponentTypeRequest,
  GetSyncJobRequest,
  ListSyncResourcesRequest,
  GetWorkspaceRequest,
  CreateEntityRequest,
  GetComponentTypeRequest,
  DeleteSyncJobRequest,
  GetSceneRequest,
  DeleteComponentTypeRequest,
  GetPricingPlanRequest,
  ExecuteQueryRequest,
  ListTagsForResourceRequest,
  UpdatePricingPlanRequest,
  GetPropertyValueHistoryRequest,
  UpdateSceneRequest,
  DeleteEntityRequest,
  ListSyncJobsRequest,
  UpdateComponentTypeRequest,
  ListEntitiesRequest,
  CreateSceneRequest,
  UpdateEntityRequest,
  UntagResourceRequest,
  UpdateWorkspaceRequest,
  GetEntityRequest,
  TagResourceRequest,
  GetPropertyValueRequest,
  DeleteSceneRequest,
  ListScenesRequest
}
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerAsyncClient
object IoTTwinMakerMock extends Mock[IoTTwinMaker] {
  object CreateComponentType
      extends Effect[
        CreateComponentTypeRequest,
        AwsError,
        zio.aws.iottwinmaker.model.CreateComponentTypeResponse.ReadOnly
      ]
  object ListEntities
      extends Effect[
        ListEntitiesRequest,
        AwsError,
        zio.aws.iottwinmaker.model.ListEntitiesResponse.ReadOnly
      ]
  object DeleteEntity
      extends Effect[
        DeleteEntityRequest,
        AwsError,
        zio.aws.iottwinmaker.model.DeleteEntityResponse.ReadOnly
      ]
  object CreateWorkspace
      extends Effect[
        CreateWorkspaceRequest,
        AwsError,
        zio.aws.iottwinmaker.model.CreateWorkspaceResponse.ReadOnly
      ]
  object DeleteScene
      extends Effect[
        DeleteSceneRequest,
        AwsError,
        zio.aws.iottwinmaker.model.DeleteSceneResponse.ReadOnly
      ]
  object ListComponentTypes
      extends Effect[
        ListComponentTypesRequest,
        AwsError,
        zio.aws.iottwinmaker.model.ListComponentTypesResponse.ReadOnly
      ]
  object ExecuteQuery
      extends Effect[
        ExecuteQueryRequest,
        AwsError,
        zio.aws.iottwinmaker.model.ExecuteQueryResponse.ReadOnly
      ]
  object CreateSyncJob extends Effect[CreateSyncJobRequest, AwsError, ReadOnly]
  object ListWorkspaces
      extends Effect[
        ListWorkspacesRequest,
        AwsError,
        zio.aws.iottwinmaker.model.ListWorkspacesResponse.ReadOnly
      ]
  object GetComponentType
      extends Effect[
        GetComponentTypeRequest,
        AwsError,
        zio.aws.iottwinmaker.model.GetComponentTypeResponse.ReadOnly
      ]
  object DeleteComponentType
      extends Effect[
        DeleteComponentTypeRequest,
        AwsError,
        zio.aws.iottwinmaker.model.DeleteComponentTypeResponse.ReadOnly
      ]
  object ListSyncJobs
      extends Effect[
        ListSyncJobsRequest,
        AwsError,
        zio.aws.iottwinmaker.model.ListSyncJobsResponse.ReadOnly
      ]
  object CreateScene
      extends Effect[
        CreateSceneRequest,
        AwsError,
        zio.aws.iottwinmaker.model.CreateSceneResponse.ReadOnly
      ]
  object GetScene
      extends Effect[
        GetSceneRequest,
        AwsError,
        zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly
      ]
  object GetSyncJob
      extends Effect[
        GetSyncJobRequest,
        AwsError,
        zio.aws.iottwinmaker.model.GetSyncJobResponse.ReadOnly
      ]
  object UpdateScene
      extends Effect[
        UpdateSceneRequest,
        AwsError,
        zio.aws.iottwinmaker.model.UpdateSceneResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.iottwinmaker.model.UntagResourceResponse.ReadOnly
      ]
  object GetEntity
      extends Effect[
        GetEntityRequest,
        AwsError,
        zio.aws.iottwinmaker.model.GetEntityResponse.ReadOnly
      ]
  object UpdateEntity
      extends Effect[
        UpdateEntityRequest,
        AwsError,
        zio.aws.iottwinmaker.model.UpdateEntityResponse.ReadOnly
      ]
  object GetPricingPlan
      extends Effect[
        GetPricingPlanRequest,
        AwsError,
        zio.aws.iottwinmaker.model.GetPricingPlanResponse.ReadOnly
      ]
  object CreateEntity
      extends Effect[
        CreateEntityRequest,
        AwsError,
        zio.aws.iottwinmaker.model.CreateEntityResponse.ReadOnly
      ]
  object DeleteSyncJob
      extends Effect[
        DeleteSyncJobRequest,
        AwsError,
        zio.aws.iottwinmaker.model.DeleteSyncJobResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iottwinmaker.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.iottwinmaker.model.TagResourceResponse.ReadOnly
      ]
  object UpdatePricingPlan
      extends Effect[
        UpdatePricingPlanRequest,
        AwsError,
        zio.aws.iottwinmaker.model.UpdatePricingPlanResponse.ReadOnly
      ]
  object BatchPutPropertyValues
      extends Effect[
        BatchPutPropertyValuesRequest,
        AwsError,
        zio.aws.iottwinmaker.model.BatchPutPropertyValuesResponse.ReadOnly
      ]
  object DeleteWorkspace
      extends Effect[
        DeleteWorkspaceRequest,
        AwsError,
        zio.aws.iottwinmaker.model.DeleteWorkspaceResponse.ReadOnly
      ]
  object ListSyncResources
      extends Effect[
        ListSyncResourcesRequest,
        AwsError,
        zio.aws.iottwinmaker.model.ListSyncResourcesResponse.ReadOnly
      ]
  object UpdateComponentType
      extends Effect[
        UpdateComponentTypeRequest,
        AwsError,
        zio.aws.iottwinmaker.model.UpdateComponentTypeResponse.ReadOnly
      ]
  object GetPropertyValueHistory
      extends Effect[
        GetPropertyValueHistoryRequest,
        AwsError,
        zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse.ReadOnly
      ]
  object GetWorkspace
      extends Effect[
        GetWorkspaceRequest,
        AwsError,
        zio.aws.iottwinmaker.model.GetWorkspaceResponse.ReadOnly
      ]
  object ListScenes
      extends Effect[
        ListScenesRequest,
        AwsError,
        zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly
      ]
  object UpdateWorkspace
      extends Effect[
        UpdateWorkspaceRequest,
        AwsError,
        zio.aws.iottwinmaker.model.UpdateWorkspaceResponse.ReadOnly
      ]
  object GetPropertyValue
      extends Effect[
        GetPropertyValueRequest,
        AwsError,
        zio.aws.iottwinmaker.model.GetPropertyValueResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, IoTTwinMaker] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, IoTTwinMaker] { rts =>
        zio.ZIO.succeed {
          new IoTTwinMaker {
            val api: IoTTwinMakerAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): IoTTwinMaker = this
            def createComponentType(request: CreateComponentTypeRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.CreateComponentTypeResponse.ReadOnly
            ] = proxy(CreateComponentType, request)
            def listEntities(request: ListEntitiesRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.ListEntitiesResponse.ReadOnly
            ] = proxy(ListEntities, request)
            def deleteEntity(request: DeleteEntityRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.DeleteEntityResponse.ReadOnly
            ] = proxy(DeleteEntity, request)
            def createWorkspace(request: CreateWorkspaceRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.CreateWorkspaceResponse.ReadOnly
            ] = proxy(CreateWorkspace, request)
            def deleteScene(request: DeleteSceneRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.DeleteSceneResponse.ReadOnly
            ] = proxy(DeleteScene, request)
            def listComponentTypes(request: ListComponentTypesRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.ListComponentTypesResponse.ReadOnly
            ] = proxy(ListComponentTypes, request)
            def executeQuery(request: ExecuteQueryRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.ExecuteQueryResponse.ReadOnly
            ] = proxy(ExecuteQuery, request)
            def createSyncJob(
                request: CreateSyncJobRequest
            ): IO[AwsError, ReadOnly] = proxy(CreateSyncJob, request)
            def listWorkspaces(request: ListWorkspacesRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.ListWorkspacesResponse.ReadOnly
            ] = proxy(ListWorkspaces, request)
            def getComponentType(request: GetComponentTypeRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.GetComponentTypeResponse.ReadOnly
            ] = proxy(GetComponentType, request)
            def deleteComponentType(request: DeleteComponentTypeRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.DeleteComponentTypeResponse.ReadOnly
            ] = proxy(DeleteComponentType, request)
            def listSyncJobs(request: ListSyncJobsRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.ListSyncJobsResponse.ReadOnly
            ] = proxy(ListSyncJobs, request)
            def createScene(request: CreateSceneRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.CreateSceneResponse.ReadOnly
            ] = proxy(CreateScene, request)
            def getScene(request: GetSceneRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.GetSceneResponse.ReadOnly
            ] = proxy(GetScene, request)
            def getSyncJob(request: GetSyncJobRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.GetSyncJobResponse.ReadOnly
            ] = proxy(GetSyncJob, request)
            def updateScene(request: UpdateSceneRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.UpdateSceneResponse.ReadOnly
            ] = proxy(UpdateScene, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def getEntity(request: GetEntityRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.GetEntityResponse.ReadOnly
            ] = proxy(GetEntity, request)
            def updateEntity(request: UpdateEntityRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.UpdateEntityResponse.ReadOnly
            ] = proxy(UpdateEntity, request)
            def getPricingPlan(request: GetPricingPlanRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.GetPricingPlanResponse.ReadOnly
            ] = proxy(GetPricingPlan, request)
            def createEntity(request: CreateEntityRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.CreateEntityResponse.ReadOnly
            ] = proxy(CreateEntity, request)
            def deleteSyncJob(request: DeleteSyncJobRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.DeleteSyncJobResponse.ReadOnly
            ] = proxy(DeleteSyncJob, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def updatePricingPlan(request: UpdatePricingPlanRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.UpdatePricingPlanResponse.ReadOnly
            ] = proxy(UpdatePricingPlan, request)
            def batchPutPropertyValues(
                request: BatchPutPropertyValuesRequest
            ): IO[
              AwsError,
              zio.aws.iottwinmaker.model.BatchPutPropertyValuesResponse.ReadOnly
            ] = proxy(BatchPutPropertyValues, request)
            def deleteWorkspace(request: DeleteWorkspaceRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.DeleteWorkspaceResponse.ReadOnly
            ] = proxy(DeleteWorkspace, request)
            def listSyncResources(request: ListSyncResourcesRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.ListSyncResourcesResponse.ReadOnly
            ] = proxy(ListSyncResources, request)
            def updateComponentType(request: UpdateComponentTypeRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.UpdateComponentTypeResponse.ReadOnly
            ] = proxy(UpdateComponentType, request)
            def getPropertyValueHistory(
                request: GetPropertyValueHistoryRequest
            ): IO[
              AwsError,
              zio.aws.iottwinmaker.model.GetPropertyValueHistoryResponse.ReadOnly
            ] = proxy(GetPropertyValueHistory, request)
            def getWorkspace(request: GetWorkspaceRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.GetWorkspaceResponse.ReadOnly
            ] = proxy(GetWorkspace, request)
            def listScenes(request: ListScenesRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.ListScenesResponse.ReadOnly
            ] = proxy(ListScenes, request)
            def updateWorkspace(request: UpdateWorkspaceRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.UpdateWorkspaceResponse.ReadOnly
            ] = proxy(UpdateWorkspace, request)
            def getPropertyValue(request: GetPropertyValueRequest): IO[
              AwsError,
              zio.aws.iottwinmaker.model.GetPropertyValueResponse.ReadOnly
            ] = proxy(GetPropertyValue, request)
          }
        }
      }
    }
  }
}
