package zio.aws.iottwinmaker.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  TwinMakerArn,
  Timestamp,
  ParentEntityId,
  Description,
  EntityId,
  EntityName
}
import scala.jdk.CollectionConverters._
final case class EntitySummary(
    entityId: EntityId,
    entityName: EntityName,
    arn: TwinMakerArn,
    parentEntityId: Optional[ParentEntityId] = Optional.Absent,
    status: zio.aws.iottwinmaker.model.Status,
    description: Optional[Description] = Optional.Absent,
    hasChildEntities: Optional[Boolean] = Optional.Absent,
    creationDateTime: Timestamp,
    updateDateTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.EntitySummary = {
    import EntitySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.EntitySummary
      .builder()
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .entityName(EntityName.unwrap(entityName): java.lang.String)
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        parentEntityId.map(value =>
          ParentEntityId.unwrap(value): java.lang.String
        )
      )(_.parentEntityId)
      .status(status.buildAwsValue())
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(hasChildEntities.map(value => value: java.lang.Boolean))(
        _.hasChildEntities
      )
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .updateDateTime(Timestamp.unwrap(updateDateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.EntitySummary.ReadOnly =
    zio.aws.iottwinmaker.model.EntitySummary.wrap(buildAwsValue())
}
object EntitySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.EntitySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.EntitySummary =
      zio.aws.iottwinmaker.model.EntitySummary(
        entityId,
        entityName,
        arn,
        parentEntityId.map(value => value),
        status.asEditable,
        description.map(value => value),
        hasChildEntities.map(value => value),
        creationDateTime,
        updateDateTime
      )
    def entityId: EntityId
    def entityName: EntityName
    def arn: TwinMakerArn
    def parentEntityId: Optional[ParentEntityId]
    def status: zio.aws.iottwinmaker.model.Status.ReadOnly
    def description: Optional[Description]
    def hasChildEntities: Optional[Boolean]
    def creationDateTime: Timestamp
    def updateDateTime: Timestamp
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getEntityName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(entityName)
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getParentEntityId: ZIO[Any, AwsError, ParentEntityId] =
      AwsError.unwrapOptionField("parentEntityId", parentEntityId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.Status.ReadOnly] =
      ZIO.succeed(status)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getHasChildEntities: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hasChildEntities", hasChildEntities)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getUpdateDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(updateDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.EntitySummary
  ) extends zio.aws.iottwinmaker.model.EntitySummary.ReadOnly {
    override val entityId: EntityId =
      zio.aws.iottwinmaker.model.primitives.EntityId(impl.entityId())
    override val entityName: EntityName =
      zio.aws.iottwinmaker.model.primitives.EntityName(impl.entityName())
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val parentEntityId: Optional[ParentEntityId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentEntityId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ParentEntityId(value)
        )
    override val status: zio.aws.iottwinmaker.model.Status.ReadOnly =
      zio.aws.iottwinmaker.model.Status.wrap(impl.status())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val hasChildEntities: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasChildEntities())
      .map(value => value: Boolean)
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val updateDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.updateDateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.EntitySummary
  ): zio.aws.iottwinmaker.model.EntitySummary.ReadOnly = new Wrapper(impl)
}
