package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdatePricingPlanResponse(
    currentPricingPlan: zio.aws.iottwinmaker.model.PricingPlan,
    pendingPricingPlan: Optional[zio.aws.iottwinmaker.model.PricingPlan] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanResponse = {
    import UpdatePricingPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanResponse
      .builder()
      .currentPricingPlan(currentPricingPlan.buildAwsValue())
      .optionallyWith(pendingPricingPlan.map(value => value.buildAwsValue()))(
        _.pendingPricingPlan
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.UpdatePricingPlanResponse.ReadOnly =
    zio.aws.iottwinmaker.model.UpdatePricingPlanResponse.wrap(buildAwsValue())
}
object UpdatePricingPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UpdatePricingPlanResponse =
      zio.aws.iottwinmaker.model.UpdatePricingPlanResponse(
        currentPricingPlan.asEditable,
        pendingPricingPlan.map(value => value.asEditable)
      )
    def currentPricingPlan: zio.aws.iottwinmaker.model.PricingPlan.ReadOnly
    def pendingPricingPlan
        : Optional[zio.aws.iottwinmaker.model.PricingPlan.ReadOnly]
    def getCurrentPricingPlan
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.PricingPlan.ReadOnly] =
      ZIO.succeed(currentPricingPlan)
    def getPendingPricingPlan
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.PricingPlan.ReadOnly] =
      AwsError.unwrapOptionField("pendingPricingPlan", pendingPricingPlan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanResponse
  ) extends zio.aws.iottwinmaker.model.UpdatePricingPlanResponse.ReadOnly {
    override val currentPricingPlan
        : zio.aws.iottwinmaker.model.PricingPlan.ReadOnly =
      zio.aws.iottwinmaker.model.PricingPlan.wrap(impl.currentPricingPlan())
    override val pendingPricingPlan
        : Optional[zio.aws.iottwinmaker.model.PricingPlan.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingPricingPlan())
        .map(value => zio.aws.iottwinmaker.model.PricingPlan.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanResponse
  ): zio.aws.iottwinmaker.model.UpdatePricingPlanResponse.ReadOnly =
    new Wrapper(impl)
}
