package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters._
sealed trait SceneErrorCode {
  def unwrap: software.amazon.awssdk.services.iottwinmaker.model.SceneErrorCode
}
object SceneErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.SceneErrorCode
  ): zio.aws.iottwinmaker.model.SceneErrorCode = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.SceneErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.SceneErrorCode.MATTERPORT_ERROR =>
      val r = MATTERPORT_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iottwinmaker.model.SceneErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SceneErrorCode =
      software.amazon.awssdk.services.iottwinmaker.model.SceneErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object MATTERPORT_ERROR
      extends zio.aws.iottwinmaker.model.SceneErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SceneErrorCode =
      software.amazon.awssdk.services.iottwinmaker.model.SceneErrorCode.MATTERPORT_ERROR
  }
}
