package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.BundleName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdatePricingPlanRequest(
    pricingMode: zio.aws.iottwinmaker.model.PricingMode,
    bundleNames: Optional[Iterable[BundleName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanRequest = {
    import UpdatePricingPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanRequest
      .builder()
      .pricingMode(pricingMode.unwrap)
      .optionallyWith(
        bundleNames.map(value =>
          value.map { item =>
            BundleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bundleNames)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.UpdatePricingPlanRequest.ReadOnly =
    zio.aws.iottwinmaker.model.UpdatePricingPlanRequest.wrap(buildAwsValue())
}
object UpdatePricingPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UpdatePricingPlanRequest =
      zio.aws.iottwinmaker.model
        .UpdatePricingPlanRequest(pricingMode, bundleNames.map(value => value))
    def pricingMode: zio.aws.iottwinmaker.model.PricingMode
    def bundleNames: Optional[List[BundleName]]
    def getPricingMode
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.PricingMode] =
      ZIO.succeed(pricingMode)
    def getBundleNames: ZIO[Any, AwsError, List[BundleName]] =
      AwsError.unwrapOptionField("bundleNames", bundleNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanRequest
  ) extends zio.aws.iottwinmaker.model.UpdatePricingPlanRequest.ReadOnly {
    override val pricingMode: zio.aws.iottwinmaker.model.PricingMode =
      zio.aws.iottwinmaker.model.PricingMode.wrap(impl.pricingMode())
    override val bundleNames: Optional[List[BundleName]] = zio.aws.core.internal
      .optionalFromNullable(impl.bundleNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.primitives.BundleName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanRequest
  ): zio.aws.iottwinmaker.model.UpdatePricingPlanRequest.ReadOnly = new Wrapper(
    impl
  )
}
