package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters._
sealed trait PropertyUpdateType {
  def unwrap
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType
}
object PropertyUpdateType {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType
  ): zio.aws.iottwinmaker.model.PropertyUpdateType = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType.UPDATE =>
      val r = UPDATE
      r
    case software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType.DELETE =>
      val r = DELETE
      r
    case software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType.CREATE =>
      val r = CREATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iottwinmaker.model.PropertyUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType =
      software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType.UNKNOWN_TO_SDK_VERSION
  }
  case object UPDATE extends zio.aws.iottwinmaker.model.PropertyUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType =
      software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType.UPDATE
  }
  case object DELETE extends zio.aws.iottwinmaker.model.PropertyUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType =
      software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType.DELETE
  }
  case object CREATE extends zio.aws.iottwinmaker.model.PropertyUpdateType {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType =
      software.amazon.awssdk.services.iottwinmaker.model.PropertyUpdateType.CREATE
  }
}
