package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{ComponentTypeId, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetComponentTypeRequest(
    workspaceId: Id,
    componentTypeId: ComponentTypeId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest = {
    import GetComponentTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .componentTypeId(
        ComponentTypeId.unwrap(componentTypeId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetComponentTypeRequest.ReadOnly =
    zio.aws.iottwinmaker.model.GetComponentTypeRequest.wrap(buildAwsValue())
}
object GetComponentTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetComponentTypeRequest =
      zio.aws.iottwinmaker.model
        .GetComponentTypeRequest(workspaceId, componentTypeId)
    def workspaceId: Id
    def componentTypeId: ComponentTypeId
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getComponentTypeId: ZIO[Any, Nothing, ComponentTypeId] =
      ZIO.succeed(componentTypeId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest
  ) extends zio.aws.iottwinmaker.model.GetComponentTypeRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val componentTypeId: ComponentTypeId =
      zio.aws.iottwinmaker.model.primitives
        .ComponentTypeId(impl.componentTypeId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest
  ): zio.aws.iottwinmaker.model.GetComponentTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
