package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  TagValue,
  ParentEntityId,
  Description,
  EntityId,
  Name,
  EntityName,
  Id,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEntityRequest(
    workspaceId: Id,
    entityId: Optional[EntityId] = Optional.Absent,
    entityName: EntityName,
    description: Optional[Description] = Optional.Absent,
    components: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentRequest]
    ] = Optional.Absent,
    parentEntityId: Optional[ParentEntityId] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest = {
    import CreateEntityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .optionallyWith(
        entityId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.entityId)
      .entityName(EntityName.unwrap(entityName): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        components.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.components)
      .optionallyWith(
        parentEntityId.map(value =>
          ParentEntityId.unwrap(value): java.lang.String
        )
      )(_.parentEntityId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.CreateEntityRequest.ReadOnly =
    zio.aws.iottwinmaker.model.CreateEntityRequest.wrap(buildAwsValue())
}
object CreateEntityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.CreateEntityRequest =
      zio.aws.iottwinmaker.model.CreateEntityRequest(
        workspaceId,
        entityId.map(value => value),
        entityName,
        description.map(value => value),
        components.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        parentEntityId.map(value => value),
        tags.map(value => value)
      )
    def workspaceId: Id
    def entityId: Optional[EntityId]
    def entityName: EntityName
    def description: Optional[Description]
    def components: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly]
    ]
    def parentEntityId: Optional[ParentEntityId]
    def tags: Optional[Map[TagKey, TagValue]]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getEntityId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getEntityName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(entityName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getComponents: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("components", components)
    def getParentEntityId: ZIO[Any, AwsError, ParentEntityId] =
      AwsError.unwrapOptionField("parentEntityId", parentEntityId)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest
  ) extends zio.aws.iottwinmaker.model.CreateEntityRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val entityId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.entityId())
      .map(value => zio.aws.iottwinmaker.model.primitives.EntityId(value))
    override val entityName: EntityName =
      zio.aws.iottwinmaker.model.primitives.EntityName(impl.entityName())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val components: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.components())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.ComponentRequest.wrap(value)
          })
          .toMap
      )
    override val parentEntityId: Optional[ParentEntityId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentEntityId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ParentEntityId(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.TagKey(
              key
            ) -> zio.aws.iottwinmaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest
  ): zio.aws.iottwinmaker.model.CreateEntityRequest.ReadOnly = new Wrapper(impl)
}
