package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TabularConditions(
    orderBy: Optional[Iterable[zio.aws.iottwinmaker.model.OrderBy]] =
      Optional.Absent,
    propertyFilters: Optional[
      Iterable[zio.aws.iottwinmaker.model.PropertyFilter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.TabularConditions = {
    import TabularConditions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.TabularConditions
      .builder()
      .optionallyWith(
        orderBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orderBy)
      .optionallyWith(
        propertyFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.propertyFilters)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.TabularConditions.ReadOnly =
    zio.aws.iottwinmaker.model.TabularConditions.wrap(buildAwsValue())
}
object TabularConditions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.TabularConditions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.TabularConditions =
      zio.aws.iottwinmaker.model.TabularConditions(
        orderBy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        propertyFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def orderBy: Optional[List[zio.aws.iottwinmaker.model.OrderBy.ReadOnly]]
    def propertyFilters
        : Optional[List[zio.aws.iottwinmaker.model.PropertyFilter.ReadOnly]]
    def getOrderBy: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.OrderBy.ReadOnly
    ]] = AwsError.unwrapOptionField("orderBy", orderBy)
    def getPropertyFilters: ZIO[Any, AwsError, List[
      zio.aws.iottwinmaker.model.PropertyFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("propertyFilters", propertyFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.TabularConditions
  ) extends zio.aws.iottwinmaker.model.TabularConditions.ReadOnly {
    override val orderBy
        : Optional[List[zio.aws.iottwinmaker.model.OrderBy.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orderBy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.OrderBy.wrap(item)
          }.toList
        )
    override val propertyFilters
        : Optional[List[zio.aws.iottwinmaker.model.PropertyFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propertyFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iottwinmaker.model.PropertyFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.TabularConditions
  ): zio.aws.iottwinmaker.model.TabularConditions.ReadOnly = new Wrapper(impl)
}
