package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PropertyRequest(
    definition: Optional[zio.aws.iottwinmaker.model.PropertyDefinitionRequest] =
      Optional.Absent,
    value: Optional[zio.aws.iottwinmaker.model.DataValue] = Optional.Absent,
    updateType: Optional[zio.aws.iottwinmaker.model.PropertyUpdateType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest = {
    import PropertyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest
      .builder()
      .optionallyWith(definition.map(value => value.buildAwsValue()))(
        _.definition
      )
      .optionallyWith(value.map(value => value.buildAwsValue()))(_.value)
      .optionallyWith(updateType.map(value => value.unwrap))(_.updateType)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyRequest.wrap(buildAwsValue())
}
object PropertyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyRequest =
      zio.aws.iottwinmaker.model.PropertyRequest(
        definition.map(value => value.asEditable),
        value.map(value => value.asEditable),
        updateType.map(value => value)
      )
    def definition: Optional[
      zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly
    ]
    def value: Optional[zio.aws.iottwinmaker.model.DataValue.ReadOnly]
    def updateType: Optional[zio.aws.iottwinmaker.model.PropertyUpdateType]
    def getDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly
    ] = AwsError.unwrapOptionField("definition", definition)
    def getValue
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      AwsError.unwrapOptionField("value", value)
    def getUpdateType
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.PropertyUpdateType] =
      AwsError.unwrapOptionField("updateType", updateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest
  ) extends zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly {
    override val definition: Optional[
      zio.aws.iottwinmaker.model.PropertyDefinitionRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.definition())
      .map(value =>
        zio.aws.iottwinmaker.model.PropertyDefinitionRequest.wrap(value)
      )
    override val value
        : Optional[zio.aws.iottwinmaker.model.DataValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value => zio.aws.iottwinmaker.model.DataValue.wrap(value))
    override val updateType
        : Optional[zio.aws.iottwinmaker.model.PropertyUpdateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateType())
        .map(value => zio.aws.iottwinmaker.model.PropertyUpdateType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyRequest
  ): zio.aws.iottwinmaker.model.PropertyRequest.ReadOnly = new Wrapper(impl)
}
