package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters._
sealed trait PricingTier {
  def unwrap: software.amazon.awssdk.services.iottwinmaker.model.PricingTier
}
object PricingTier {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.PricingTier
  ): zio.aws.iottwinmaker.model.PricingTier = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.PricingTier.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.PricingTier.TIER_1 =>
      val r = TIER_1
      r
    case software.amazon.awssdk.services.iottwinmaker.model.PricingTier.TIER_2 =>
      val r = TIER_2
      r
    case software.amazon.awssdk.services.iottwinmaker.model.PricingTier.TIER_3 =>
      val r = TIER_3
      r
    case software.amazon.awssdk.services.iottwinmaker.model.PricingTier.TIER_4 =>
      val r = TIER_4
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iottwinmaker.model.PricingTier {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.PricingTier =
      software.amazon.awssdk.services.iottwinmaker.model.PricingTier.UNKNOWN_TO_SDK_VERSION
  }
  case object TIER_1 extends zio.aws.iottwinmaker.model.PricingTier {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.PricingTier =
      software.amazon.awssdk.services.iottwinmaker.model.PricingTier.TIER_1
  }
  case object TIER_2 extends zio.aws.iottwinmaker.model.PricingTier {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.PricingTier =
      software.amazon.awssdk.services.iottwinmaker.model.PricingTier.TIER_2
  }
  case object TIER_3 extends zio.aws.iottwinmaker.model.PricingTier {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.PricingTier =
      software.amazon.awssdk.services.iottwinmaker.model.PricingTier.TIER_3
  }
  case object TIER_4 extends zio.aws.iottwinmaker.model.PricingTier {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.PricingTier =
      software.amazon.awssdk.services.iottwinmaker.model.PricingTier.TIER_4
  }
}
