package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetPricingPlanResponse(
    currentPricingPlan: zio.aws.iottwinmaker.model.PricingPlan,
    pendingPricingPlan: Optional[zio.aws.iottwinmaker.model.PricingPlan] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanResponse = {
    import GetPricingPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanResponse
      .builder()
      .currentPricingPlan(currentPricingPlan.buildAwsValue())
      .optionallyWith(pendingPricingPlan.map(value => value.buildAwsValue()))(
        _.pendingPricingPlan
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetPricingPlanResponse.ReadOnly =
    zio.aws.iottwinmaker.model.GetPricingPlanResponse.wrap(buildAwsValue())
}
object GetPricingPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetPricingPlanResponse =
      zio.aws.iottwinmaker.model.GetPricingPlanResponse(
        currentPricingPlan.asEditable,
        pendingPricingPlan.map(value => value.asEditable)
      )
    def currentPricingPlan: zio.aws.iottwinmaker.model.PricingPlan.ReadOnly
    def pendingPricingPlan
        : Optional[zio.aws.iottwinmaker.model.PricingPlan.ReadOnly]
    def getCurrentPricingPlan
        : ZIO[Any, Nothing, zio.aws.iottwinmaker.model.PricingPlan.ReadOnly] =
      ZIO.succeed(currentPricingPlan)
    def getPendingPricingPlan
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.PricingPlan.ReadOnly] =
      AwsError.unwrapOptionField("pendingPricingPlan", pendingPricingPlan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanResponse
  ) extends zio.aws.iottwinmaker.model.GetPricingPlanResponse.ReadOnly {
    override val currentPricingPlan
        : zio.aws.iottwinmaker.model.PricingPlan.ReadOnly =
      zio.aws.iottwinmaker.model.PricingPlan.wrap(impl.currentPricingPlan())
    override val pendingPricingPlan
        : Optional[zio.aws.iottwinmaker.model.PricingPlan.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingPricingPlan())
        .map(value => zio.aws.iottwinmaker.model.PricingPlan.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanResponse
  ): zio.aws.iottwinmaker.model.GetPricingPlanResponse.ReadOnly = new Wrapper(
    impl
  )
}
