package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{
  Description,
  EntityId,
  Name,
  EntityName,
  Id
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEntityRequest(
    workspaceId: Id,
    entityId: EntityId,
    entityName: Optional[EntityName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    componentUpdates: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentUpdateRequest]
    ] = Optional.Absent,
    parentEntityUpdate: Optional[
      zio.aws.iottwinmaker.model.ParentEntityUpdateRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest = {
    import UpdateEntityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .optionallyWith(
        entityName.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.entityName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        componentUpdates.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.componentUpdates)
      .optionallyWith(parentEntityUpdate.map(value => value.buildAwsValue()))(
        _.parentEntityUpdate
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.UpdateEntityRequest.ReadOnly =
    zio.aws.iottwinmaker.model.UpdateEntityRequest.wrap(buildAwsValue())
}
object UpdateEntityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.UpdateEntityRequest =
      zio.aws.iottwinmaker.model.UpdateEntityRequest(
        workspaceId,
        entityId,
        entityName.map(value => value),
        description.map(value => value),
        componentUpdates.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        parentEntityUpdate.map(value => value.asEditable)
      )
    def workspaceId: Id
    def entityId: EntityId
    def entityName: Optional[EntityName]
    def description: Optional[Description]
    def componentUpdates: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentUpdateRequest.ReadOnly]
    ]
    def parentEntityUpdate: Optional[
      zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.ReadOnly
    ]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
    def getEntityName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("entityName", entityName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getComponentUpdates: ZIO[Any, AwsError, Map[
      Name,
      zio.aws.iottwinmaker.model.ComponentUpdateRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("componentUpdates", componentUpdates)
    def getParentEntityUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.ReadOnly
    ] = AwsError.unwrapOptionField("parentEntityUpdate", parentEntityUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest
  ) extends zio.aws.iottwinmaker.model.UpdateEntityRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val entityId: EntityId =
      zio.aws.iottwinmaker.model.primitives.EntityId(impl.entityId())
    override val entityName: Optional[EntityName] = zio.aws.core.internal
      .optionalFromNullable(impl.entityName())
      .map(value => zio.aws.iottwinmaker.model.primitives.EntityName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iottwinmaker.model.primitives.Description(value))
    override val componentUpdates: Optional[
      Map[Name, zio.aws.iottwinmaker.model.ComponentUpdateRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.componentUpdates())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iottwinmaker.model.primitives.Name(
              key
            ) -> zio.aws.iottwinmaker.model.ComponentUpdateRequest.wrap(value)
          })
          .toMap
      )
    override val parentEntityUpdate: Optional[
      zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parentEntityUpdate())
      .map(value =>
        zio.aws.iottwinmaker.model.ParentEntityUpdateRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest
  ): zio.aws.iottwinmaker.model.UpdateEntityRequest.ReadOnly = new Wrapper(impl)
}
