package zio.aws.iottwinmaker.model
import scala.jdk.CollectionConverters._
sealed trait SyncJobState {
  def unwrap: software.amazon.awssdk.services.iottwinmaker.model.SyncJobState
}
object SyncJobState {
  def wrap(
      value: software.amazon.awssdk.services.iottwinmaker.model.SyncJobState
  ): zio.aws.iottwinmaker.model.SyncJobState = value match {
    case software.amazon.awssdk.services.iottwinmaker.model.SyncJobState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iottwinmaker.model.SyncJobState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.iottwinmaker.model.SyncJobState.INITIALIZING =>
      val r = INITIALIZING
      r
    case software.amazon.awssdk.services.iottwinmaker.model.SyncJobState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.iottwinmaker.model.SyncJobState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.iottwinmaker.model.SyncJobState.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iottwinmaker.model.SyncJobState {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncJobState =
      software.amazon.awssdk.services.iottwinmaker.model.SyncJobState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.iottwinmaker.model.SyncJobState {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncJobState =
      software.amazon.awssdk.services.iottwinmaker.model.SyncJobState.CREATING
  }
  case object INITIALIZING extends zio.aws.iottwinmaker.model.SyncJobState {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncJobState =
      software.amazon.awssdk.services.iottwinmaker.model.SyncJobState.INITIALIZING
  }
  case object ACTIVE extends zio.aws.iottwinmaker.model.SyncJobState {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncJobState =
      software.amazon.awssdk.services.iottwinmaker.model.SyncJobState.ACTIVE
  }
  case object DELETING extends zio.aws.iottwinmaker.model.SyncJobState {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncJobState =
      software.amazon.awssdk.services.iottwinmaker.model.SyncJobState.DELETING
  }
  case object ERROR extends zio.aws.iottwinmaker.model.SyncJobState {
    override def unwrap
        : software.amazon.awssdk.services.iottwinmaker.model.SyncJobState =
      software.amazon.awssdk.services.iottwinmaker.model.SyncJobState.ERROR
  }
}
