package zio.aws.iottwinmaker.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  NextToken,
  EntityId,
  MaxResults,
  ComponentTypeId,
  Name,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetPropertyValueRequest(
    componentName: Optional[Name] = Optional.Absent,
    componentTypeId: Optional[ComponentTypeId] = Optional.Absent,
    entityId: Optional[EntityId] = Optional.Absent,
    selectedProperties: Iterable[String],
    workspaceId: Id,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    propertyGroupName: Optional[Name] = Optional.Absent,
    tabularConditions: Optional[zio.aws.iottwinmaker.model.TabularConditions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest = {
    import GetPropertyValueRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest
      .builder()
      .optionallyWith(
        componentName.map(value => Name.unwrap(value): java.lang.String)
      )(_.componentName)
      .optionallyWith(
        componentTypeId.map(value =>
          ComponentTypeId.unwrap(value): java.lang.String
        )
      )(_.componentTypeId)
      .optionallyWith(
        entityId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.entityId)
      .selectedProperties(selectedProperties.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        propertyGroupName.map(value => Name.unwrap(value): java.lang.String)
      )(_.propertyGroupName)
      .optionallyWith(tabularConditions.map(value => value.buildAwsValue()))(
        _.tabularConditions
      )
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetPropertyValueRequest.ReadOnly =
    zio.aws.iottwinmaker.model.GetPropertyValueRequest.wrap(buildAwsValue())
}
object GetPropertyValueRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetPropertyValueRequest =
      zio.aws.iottwinmaker.model.GetPropertyValueRequest(
        componentName.map(value => value),
        componentTypeId.map(value => value),
        entityId.map(value => value),
        selectedProperties,
        workspaceId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        propertyGroupName.map(value => value),
        tabularConditions.map(value => value.asEditable)
      )
    def componentName: Optional[Name]
    def componentTypeId: Optional[ComponentTypeId]
    def entityId: Optional[EntityId]
    def selectedProperties: List[String]
    def workspaceId: Id
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def propertyGroupName: Optional[Name]
    def tabularConditions
        : Optional[zio.aws.iottwinmaker.model.TabularConditions.ReadOnly]
    def getComponentName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getComponentTypeId: ZIO[Any, AwsError, ComponentTypeId] =
      AwsError.unwrapOptionField("componentTypeId", componentTypeId)
    def getEntityId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getSelectedProperties: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(selectedProperties)
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPropertyGroupName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("propertyGroupName", propertyGroupName)
    def getTabularConditions: ZIO[
      Any,
      AwsError,
      zio.aws.iottwinmaker.model.TabularConditions.ReadOnly
    ] = AwsError.unwrapOptionField("tabularConditions", tabularConditions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest
  ) extends zio.aws.iottwinmaker.model.GetPropertyValueRequest.ReadOnly {
    override val componentName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.componentName())
      .map(value => zio.aws.iottwinmaker.model.primitives.Name(value))
    override val componentTypeId: Optional[ComponentTypeId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.componentTypeId())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.ComponentTypeId(value)
        )
    override val entityId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.entityId())
      .map(value => zio.aws.iottwinmaker.model.primitives.EntityId(value))
    override val selectedProperties: List[String] = impl
      .selectedProperties()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iottwinmaker.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
    override val propertyGroupName: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyGroupName())
      .map(value => zio.aws.iottwinmaker.model.primitives.Name(value))
    override val tabularConditions
        : Optional[zio.aws.iottwinmaker.model.TabularConditions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tabularConditions())
        .map(value => zio.aws.iottwinmaker.model.TabularConditions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest
  ): zio.aws.iottwinmaker.model.GetPropertyValueRequest.ReadOnly = new Wrapper(
    impl
  )
}
