package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{EntityId, Id}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetEntityRequest(workspaceId: Id, entityId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest = {
    import GetEntityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .entityId(EntityId.unwrap(entityId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.GetEntityRequest.ReadOnly =
    zio.aws.iottwinmaker.model.GetEntityRequest.wrap(buildAwsValue())
}
object GetEntityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.GetEntityRequest =
      zio.aws.iottwinmaker.model.GetEntityRequest(workspaceId, entityId)
    def workspaceId: Id
    def entityId: EntityId
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getEntityId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(entityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest
  ) extends zio.aws.iottwinmaker.model.GetEntityRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val entityId: EntityId =
      zio.aws.iottwinmaker.model.primitives.EntityId(impl.entityId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest
  ): zio.aws.iottwinmaker.model.GetEntityRequest.ReadOnly = new Wrapper(impl)
}
