package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PropertyGroupRequest(
    groupType: Optional[zio.aws.iottwinmaker.model.GroupType] = Optional.Absent,
    propertyNames: Optional[Iterable[Name]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupRequest = {
    import PropertyGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupRequest
      .builder()
      .optionallyWith(groupType.map(value => value.unwrap))(_.groupType)
      .optionallyWith(
        propertyNames.map(value =>
          value.map { item =>
            Name.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.propertyNames)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.PropertyGroupRequest.ReadOnly =
    zio.aws.iottwinmaker.model.PropertyGroupRequest.wrap(buildAwsValue())
}
object PropertyGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.PropertyGroupRequest =
      zio.aws.iottwinmaker.model.PropertyGroupRequest(
        groupType.map(value => value),
        propertyNames.map(value => value)
      )
    def groupType: Optional[zio.aws.iottwinmaker.model.GroupType]
    def propertyNames: Optional[List[Name]]
    def getGroupType: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.GroupType] =
      AwsError.unwrapOptionField("groupType", groupType)
    def getPropertyNames: ZIO[Any, AwsError, List[Name]] =
      AwsError.unwrapOptionField("propertyNames", propertyNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupRequest
  ) extends zio.aws.iottwinmaker.model.PropertyGroupRequest.ReadOnly {
    override val groupType: Optional[zio.aws.iottwinmaker.model.GroupType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupType())
        .map(value => zio.aws.iottwinmaker.model.GroupType.wrap(value))
    override val propertyNames: Optional[List[Name]] = zio.aws.core.internal
      .optionalFromNullable(impl.propertyNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iottwinmaker.model.primitives.Name(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.PropertyGroupRequest
  ): zio.aws.iottwinmaker.model.PropertyGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
