package zio.aws.iottwinmaker.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iottwinmaker.model.primitives.{
  NextToken,
  QueryServiceMaxResults,
  QueryStatement,
  Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ExecuteQueryRequest(
    workspaceId: Id,
    queryStatement: QueryStatement,
    maxResults: Optional[QueryServiceMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest = {
    import ExecuteQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest
      .builder()
      .workspaceId(Id.unwrap(workspaceId): java.lang.String)
      .queryStatement(QueryStatement.unwrap(queryStatement): java.lang.String)
      .optionallyWith(
        maxResults.map(value => QueryServiceMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.ExecuteQueryRequest.ReadOnly =
    zio.aws.iottwinmaker.model.ExecuteQueryRequest.wrap(buildAwsValue())
}
object ExecuteQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.ExecuteQueryRequest =
      zio.aws.iottwinmaker.model.ExecuteQueryRequest(
        workspaceId,
        queryStatement,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def workspaceId: Id
    def queryStatement: QueryStatement
    def maxResults: Optional[QueryServiceMaxResults]
    def nextToken: Optional[NextToken]
    def getWorkspaceId: ZIO[Any, Nothing, Id] = ZIO.succeed(workspaceId)
    def getQueryStatement: ZIO[Any, Nothing, QueryStatement] =
      ZIO.succeed(queryStatement)
    def getMaxResults: ZIO[Any, AwsError, QueryServiceMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest
  ) extends zio.aws.iottwinmaker.model.ExecuteQueryRequest.ReadOnly {
    override val workspaceId: Id =
      zio.aws.iottwinmaker.model.primitives.Id(impl.workspaceId())
    override val queryStatement: QueryStatement =
      zio.aws.iottwinmaker.model.primitives
        .QueryStatement(impl.queryStatement())
    override val maxResults: Optional[QueryServiceMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.iottwinmaker.model.primitives.QueryServiceMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iottwinmaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest
  ): zio.aws.iottwinmaker.model.ExecuteQueryRequest.ReadOnly = new Wrapper(impl)
}
