package zio.aws.iottwinmaker.model
import zio.aws.iottwinmaker.model.primitives.{Timestamp, TwinMakerArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class CreateSyncJobResponse(
    arn: TwinMakerArn,
    creationDateTime: Timestamp,
    state: zio.aws.iottwinmaker.model.SyncJobState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobResponse = {
    import CreateSyncJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobResponse
      .builder()
      .arn(TwinMakerArn.unwrap(arn): java.lang.String)
      .creationDateTime(Timestamp.unwrap(creationDateTime): Instant)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.CreateSyncJobResponse.ReadOnly =
    zio.aws.iottwinmaker.model.CreateSyncJobResponse.wrap(buildAwsValue())
}
object CreateSyncJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.CreateSyncJobResponse =
      zio.aws.iottwinmaker.model
        .CreateSyncJobResponse(arn, creationDateTime, state)
    def arn: TwinMakerArn
    def creationDateTime: Timestamp
    def state: zio.aws.iottwinmaker.model.SyncJobState
    def getArn: ZIO[Any, Nothing, TwinMakerArn] = ZIO.succeed(arn)
    def getCreationDateTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDateTime)
    def getState: ZIO[Any, Nothing, zio.aws.iottwinmaker.model.SyncJobState] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobResponse
  ) extends zio.aws.iottwinmaker.model.CreateSyncJobResponse.ReadOnly {
    override val arn: TwinMakerArn =
      zio.aws.iottwinmaker.model.primitives.TwinMakerArn(impl.arn())
    override val creationDateTime: Timestamp =
      zio.aws.iottwinmaker.model.primitives.Timestamp(impl.creationDateTime())
    override val state: zio.aws.iottwinmaker.model.SyncJobState =
      zio.aws.iottwinmaker.model.SyncJobState.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobResponse
  ): zio.aws.iottwinmaker.model.CreateSyncJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
