package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SyncJobStatus(
    state: Optional[zio.aws.iottwinmaker.model.SyncJobState] = Optional.Absent,
    error: Optional[zio.aws.iottwinmaker.model.ErrorDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.SyncJobStatus = {
    import SyncJobStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.SyncJobStatus
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.SyncJobStatus.ReadOnly =
    zio.aws.iottwinmaker.model.SyncJobStatus.wrap(buildAwsValue())
}
object SyncJobStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.SyncJobStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.SyncJobStatus =
      zio.aws.iottwinmaker.model.SyncJobStatus(
        state.map(value => value),
        error.map(value => value.asEditable)
      )
    def state: Optional[zio.aws.iottwinmaker.model.SyncJobState]
    def error: Optional[zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly]
    def getState: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.SyncJobState] =
      AwsError.unwrapOptionField("state", state)
    def getError
        : ZIO[Any, AwsError, zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SyncJobStatus
  ) extends zio.aws.iottwinmaker.model.SyncJobStatus.ReadOnly {
    override val state: Optional[zio.aws.iottwinmaker.model.SyncJobState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.iottwinmaker.model.SyncJobState.wrap(value))
    override val error
        : Optional[zio.aws.iottwinmaker.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.error())
        .map(value => zio.aws.iottwinmaker.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.SyncJobStatus
  ): zio.aws.iottwinmaker.model.SyncJobStatus.ReadOnly = new Wrapper(impl)
}
