package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OrderBy(
    order: Optional[zio.aws.iottwinmaker.model.Order] = Optional.Absent,
    propertyName: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.OrderBy = {
    import OrderBy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.OrderBy
      .builder()
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .propertyName(propertyName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iottwinmaker.model.OrderBy.ReadOnly =
    zio.aws.iottwinmaker.model.OrderBy.wrap(buildAwsValue())
}
object OrderBy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.OrderBy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.OrderBy =
      zio.aws.iottwinmaker.model
        .OrderBy(order.map(value => value), propertyName)
    def order: Optional[zio.aws.iottwinmaker.model.Order]
    def propertyName: String
    def getOrder: ZIO[Any, AwsError, zio.aws.iottwinmaker.model.Order] =
      AwsError.unwrapOptionField("order", order)
    def getPropertyName: ZIO[Any, Nothing, String] = ZIO.succeed(propertyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.OrderBy
  ) extends zio.aws.iottwinmaker.model.OrderBy.ReadOnly {
    override val order: Optional[zio.aws.iottwinmaker.model.Order] =
      zio.aws.core.internal
        .optionalFromNullable(impl.order())
        .map(value => zio.aws.iottwinmaker.model.Order.wrap(value))
    override val propertyName: String = impl.propertyName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.OrderBy
  ): zio.aws.iottwinmaker.model.OrderBy.ReadOnly = new Wrapper(impl)
}
