package zio.aws.iottwinmaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchPutPropertyValuesResponse(
    errorEntries: Iterable[
      zio.aws.iottwinmaker.model.BatchPutPropertyErrorEntry
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesResponse = {
    import BatchPutPropertyValuesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesResponse
      .builder()
      .errorEntries(errorEntries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iottwinmaker.model.BatchPutPropertyValuesResponse.ReadOnly =
    zio.aws.iottwinmaker.model.BatchPutPropertyValuesResponse
      .wrap(buildAwsValue())
}
object BatchPutPropertyValuesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iottwinmaker.model.BatchPutPropertyValuesResponse =
      zio.aws.iottwinmaker.model
        .BatchPutPropertyValuesResponse(errorEntries.map { item =>
          item.asEditable
        })
    def errorEntries
        : List[zio.aws.iottwinmaker.model.BatchPutPropertyErrorEntry.ReadOnly]
    def getErrorEntries: ZIO[Any, Nothing, List[
      zio.aws.iottwinmaker.model.BatchPutPropertyErrorEntry.ReadOnly
    ]] = ZIO.succeed(errorEntries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesResponse
  ) extends zio.aws.iottwinmaker.model.BatchPutPropertyValuesResponse.ReadOnly {
    override val errorEntries
        : List[zio.aws.iottwinmaker.model.BatchPutPropertyErrorEntry.ReadOnly] =
      impl
        .errorEntries()
        .asScala
        .map { item =>
          zio.aws.iottwinmaker.model.BatchPutPropertyErrorEntry.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesResponse
  ): zio.aws.iottwinmaker.model.BatchPutPropertyValuesResponse.ReadOnly =
    new Wrapper(impl)
}
